<nav class="fixed bottom-0 left-0 right-0 bg-white dark:bg-[#0F0A1F] border-t border-gray-100/50 dark:border-gray-800/50 md:hidden z-50">
   <div class="max-w-screen-xl mx-auto">
       <div class="grid grid-cols-5 w-full">
           {{-- History --}}
           <a href="{{ route('user.transactions.deposit') }}" 
               @if($settings->spa_mode) wire:navigate @endif 
               @class(['group relative flex flex-col items-center justify-center px-2 py-4 transition-colors',
                   'text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.transactions.*'),
                   'text-gray-600 dark:text-gray-400' => !request()->routeIs('user.transactions.*')])>
               <div class="relative w-10 h-10 flex items-center justify-center">
                   <div class="w-full h-full absolute bg-cyan-500/5 dark:bg-[#2FE6DE]/5 rounded-xl group-hover:bg-cyan-500/10 dark:group-hover:bg-[#2FE6DE]/10 transition-colors"></div>
                   <i class="fas fa-clock-rotate-left w-5 h-5"></i>
                   <div class="absolute inset-0 bg-cyan-500/10 dark:bg-[#2FE6DE]/10 rounded-xl scale-0 group-hover:scale-100 transition-transform"></div>
               </div>
               <span class="text-xs mt-1 font-medium group-hover:text-cyan-500 dark:group-hover:text-[#2FE6DE] transition-colors">History</span>
               @if(request()->routeIs('user.transactions.*'))
                   <div class="absolute top-0 left-1/2 -translate-x-1/2 w-8 h-1 bg-cyan-500 dark:bg-[#2FE6DE] rounded-b-full"></div>
               @endif
           </a>

           {{-- Deposit with Animation --}}
           <a href="{{ route('user.deposit.make') }}" 
               @if($settings->spa_mode) wire:navigate @endif
               @class(['group relative flex flex-col items-center justify-center px-2 py-4 transition-colors',
                   'text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.deposit.*'),
                   'text-gray-600 dark:text-gray-400' => !request()->routeIs('user.deposit.*')])>
               <div class="relative w-10 h-10 flex items-center justify-center animate-bounce">
                   <div class="w-full h-full absolute bg-cyan-500/5 dark:bg-[#2FE6DE]/5 rounded-xl group-hover:bg-cyan-500/10 dark:group-hover:bg-[#2FE6DE]/10 transition-colors"></div>
                   <i class="fas fa-coins w-5 h-5"></i>
                   <div class="absolute inset-0 bg-cyan-500/10 dark:bg-[#2FE6DE]/10 rounded-xl scale-0 group-hover:scale-100 transition-transform"></div>
               </div>
               <span class="text-xs mt-1 font-medium group-hover:text-cyan-500 dark:group-hover:text-[#2FE6DE] transition-colors">Deposit</span>
               @if(request()->routeIs('user.deposit.*'))
                   <div class="absolute top-0 left-1/2 -translate-x-1/2 w-8 h-1 bg-cyan-500 dark:bg-[#2FE6DE] rounded-b-full"></div>
               @endif
           </a>

           {{-- Dashboard (Home) --}}
           <a href="{{ route('user.dashboard') }}" 
               @if($settings->spa_mode) wire:navigate @endif
               @class(['group relative flex flex-col items-center justify-center px-2 py-4 transition-colors',
                   'text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.dashboard'),
                   'text-gray-600 dark:text-gray-400' => !request()->routeIs('user.dashboard')])>
               <div class="relative w-10 h-10 flex items-center justify-center">
                   <div class="w-full h-full absolute bg-cyan-500/5 dark:bg-[#2FE6DE]/5 rounded-xl group-hover:bg-cyan-500/10 dark:group-hover:bg-[#2FE6DE]/10 transition-colors"></div>
                   <i class="fas fa-home w-5 h-5"></i>
                   <div class="absolute inset-0 bg-cyan-500/10 dark:bg-[#2FE6DE]/10 rounded-xl scale-0 group-hover:scale-100 transition-transform"></div>
               </div>
               <span class="text-xs mt-1 font-medium group-hover:text-cyan-500 dark:group-hover:text-[#2FE6DE] transition-colors">Home</span>
               @if(request()->routeIs('user.dashboard'))
                   <div class="absolute top-0 left-1/2 -translate-x-1/2 w-8 h-1 bg-cyan-500 dark:bg-[#2FE6DE] rounded-b-full"></div>
               @endif
           </a>

           {{-- Withdraw --}}
           <a href="{{ route('user.withdraw.request') }}" 
               @if($settings->spa_mode) wire:navigate @endif
               @class(['group relative flex flex-col items-center justify-center px-2 py-4 transition-colors',
                   'text-cyan-500 dark:text-[#2FE6DE]' => request()->routeIs('user.withdraw.*'),
                   'text-gray-600 dark:text-gray-400' => !request()->routeIs('user.withdraw.*')])>
               <div class="relative w-10 h-10 flex items-center justify-center">
                   <div class="w-full h-full absolute bg-cyan-500/5 dark:bg-[#2FE6DE]/5 rounded-xl group-hover:bg-cyan-500/10 dark:group-hover:bg-[#2FE6DE]/10 transition-colors"></div>
                   <i class="fas fa-wallet w-5 h-5"></i>
                   <div class="absolute inset-0 bg-cyan-500/10 dark:bg-[#2FE6DE]/10 rounded-xl scale-0 group-hover:scale-100 transition-transform"></div>
               </div>
               <span class="text-xs mt-1 font-medium group-hover:text-cyan-500 dark:group-hover:text-[#2FE6DE] transition-colors">Withdraw</span>
               @if(request()->routeIs('user.withdraw.*'))
                   <div class="absolute top-0 left-1/2 -translate-x-1/2 w-8 h-1 bg-cyan-500 dark:bg-[#2FE6DE] rounded-b-full"></div>
               @endif
           </a>

           {{-- Menu Toggle --}}
           <button id="mobileMenuToggle" 
               class="group relative flex flex-col items-center justify-center px-2 py-4 w-full text-gray-600 dark:text-gray-400">
               <div class="relative w-10 h-10 flex items-center justify-center">
                   <div class="w-full h-full absolute bg-cyan-500/5 dark:bg-[#2FE6DE]/5 rounded-xl group-hover:bg-cyan-500/10 dark:group-hover:bg-[#2FE6DE]/10 transition-colors"></div>
                   <i class="fas fa-ellipsis w-5 h-5"></i>
                   <div class="absolute inset-0 bg-cyan-500/10 dark:bg-[#2FE6DE]/10 rounded-xl scale-0 group-hover:scale-100 transition-transform"></div>
               </div>
               <span class="text-xs mt-1 font-medium group-hover:text-cyan-500 dark:group-hover:text-[#2FE6DE] transition-colors">Menu</span>
           </button>
       </div>
   </div>
</nav>

@push('scripts')
<script>
    // Mobile menu toggle functionality
    document.addEventListener('DOMContentLoaded', function() {
        const mobileMenuToggle = document.getElementById('mobileMenuToggle');
        const mobileSidebar = document.getElementById('mobileSidebar');
        const closeMobileSidebar = document.getElementById('closeMobileSidebar');

        if (mobileMenuToggle && mobileSidebar && closeMobileSidebar) {
            // Toggle menu
            mobileMenuToggle.addEventListener('click', () => {
                mobileSidebar.classList.toggle('hidden');
            });

            // Close menu
            closeMobileSidebar.addEventListener('click', () => {
                mobileSidebar.classList.add('hidden');
            });

            // Close on outside click
            mobileSidebar.addEventListener('click', (e) => {
                if (e.target === mobileSidebar) {
                    mobileSidebar.classList.add('hidden');
                }
            });
        }
    });
</script>
@endpush