<div class="px-2 space-y-6 mb-5 mt-2 md:mb-1">
    {{-- Header Section 
    <div class="pl-3 flex items-center justify-between">
        <div>
            <div class="flex items-center text-sm text-gray-400">
                <a href="{{ route('user.dashboard') }}" class="hover:text-theme-primary">{{ __('t.dash') }}</a>
                <i data-lucide="chevron-right" class="w-4 h-4 mx-2"></i>
                <span>{{ __('t.withdrawals') }}</span>
            </div>
        </div>
    </div> --}}
     <x-danger-alert />
    <x-success-alert />

    {{-- Transaction Card --}}
    <div class="bg-theme-secondary rounded-2xl">
        {{-- Navigation Tabs --}}
        <div class="flex pt-2 pl-2">
            <a href="{{ route('user.transactions.deposit') }}"
                @if($settings->spa_mode) wire:navigate @endif
                class="flex-1 flex items-center justify-center gap-2 px-4 py-3 rounded-xl hover:bg-theme-tertiary text-gray-400 hover:text-theme-primary transition-colors">
               <i class="fas fa-arrow-down" style="font-size: 1rem;"></i>
                {{ __('t.deposit') }}
            </a>
            <a href="{{ route('user.transactions.withdrawal') }}"
                @if($settings->spa_mode) wire:navigate @endif
                class="flex-1 flex items-center justify-center gap-2 px-4 py-3 rounded-xl bg-theme-primary/10 text-theme-primary">
              <i class="fas fa-arrow-up" style="font-size: 1rem;"></i>
                {{ __('t.withdraw') }}
            </a>
            <a href="{{ route('user.transactions.others') }}"
                @if($settings->spa_mode) wire:navigate @endif
                class="flex-1 flex items-center justify-center gap-2 px-4 py-3 rounded-xl hover:bg-theme-tertiary text-gray-400 hover:text-theme-primary transition-colors">
               <i class="fas fa-list" style="font-size: 1rem;"></i>
                {{ __('t.others') }}
            </a>
        </div>

        {{-- Transaction List --}}
        <div class="p-6 space-y-4">
            @forelse($this->withdrawals as $withdrawal)
                <div class="bg-theme-tertiary rounded-xl p-4 hover:bg-theme-quaternary transition-colors">
                    <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                        <div class="flex items-center gap-4">
                            <div class="bg-theme-primary/10 p-3 rounded-xl">
                                <i data-lucide="wallet" class="w-6 h-6 text-theme-primary"></i>
                            </div>
                            <div>
                                <div class="text-lg font-medium">{{ Number::currency($withdrawal->amount, $settings->s_currency) }}</div>
                                <div class="text-sm text-gray-400">{{ __('t.via') }} {{ $withdrawal->payment_mode }}</div>
                            </div>
                        </div>
                        
                        <div class="flex items-center gap-4">
                            @if($withdrawal->status == 'pending')
                                <div class="px-4 py-2 rounded-xl bg-yellow-400/10 text-yellow-400 text-sm">
                                    <div class="flex items-center gap-2">
                                        <i class="fas fa-clock" style="font-size: 1rem;"></i>
                                        {{ Str::ucfirst($withdrawal->status) }}
                                    </div>
                                </div>
                            @elseif($withdrawal->status == 'processed')
                                <div class="px-4 py-2 rounded-xl bg-theme-primary/10 text-theme-primary text-sm">
                                    <div class="flex items-center gap-2">
                                        <i class="fas fa-check-circle" style="font-size: 1rem;"></i>
                                        {{ Str::ucfirst($withdrawal->status) }}
                                    </div>
                                </div>
                            @else
                                <div class="px-4 py-2 rounded-xl bg-red-400/10 text-red-400 text-sm">
                                    <div class="flex items-center gap-2">
                                       <i class="fas fa-times-circle" style="font-size: 1rem;"></i>
                                       {{ Str::ucfirst($withdrawal->status) }}
                                    </div>
                                </div>
                            @endif
                            
                            <div class="text-sm text-gray-400">
                                {{ $withdrawal->created_at->format('M d, Y h:i A') }}
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="py-12 text-center">
                    <div class="bg-theme-tertiary w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <i data-lucide="inbox" class="w-8 h-8 text-gray-400"></i>
                    </div>
                    <h3 class="text-lg font-medium text-gray-400">{{ __('t.no_transactions') }}</h3>
                    <p class="text-gray-500 text-sm mt-1">{{ __('t.transaction_history') }}</p>
                </div>
            @endforelse

            {{-- Pagination --}}
            <div class="mt-6">
                {{ $this->withdrawals->links() }}
            </div>
        </div>
    </div>
</div>



