<div class="space-y-6">
    
    <div class="flex items-center justify-between">
      {{--  <div>
            <div class="pl-3 flex items-center text-sm text-gray-400">
                <a href="{{ route('user.dashboard') }}" class="hover:text-theme-primary">{{ __('t.dash') }}</a>
                <i class="fas fa-chevron-right" style="font-size: 1rem; margin: 0 0.5rem;"></i>
                <span>{{ __('t.notify') }}</span>
            </div>
        </div> --}}
        <x-danger-alert />
    <x-success-alert />
        
        {{-- Action Buttons --}}
        <div class="flex items-center gap-3 pr-3 pt-3">
            @if($user->unreadNotifications->count() > 0)
                <button wire:click="markAllAsRead" 
                    class="flex items-center gap-2 px-4 py-2 bg-theme-tertiary text-theme-primary rounded-xl hover:bg-theme-quaternary transition-colors">
                    <i class="fas fa-check-circle" style="font-size: 1rem;"></i>
                    <span>{{ __('t.mark_all_read') }}</span>
                </button>
            @endif
        </div>
    </div>

    {{-- Notifications List --}}
    <div class="bg-theme-secondary rounded-2xl p-6">
        <div class="space-y-4">
            @forelse($notifications as $notification)
                <div class="bg-theme-tertiary rounded-xl p-4 hover:bg-theme-quaternary transition-colors relative overflow-hidden
                    {{ !$notification->read_at ? 'border-l-4 border-theme-primary' : '' }}">
                    
                    {{-- Unread Indicator --}}
                    @if(!$notification->read_at)
                        <div class="absolute top-4 right-4 w-2 h-2 rounded-full bg-theme-primary"></div>
                    @endif

                    <div class="flex items-start gap-4">
                        {{-- Notification Icon based on type --}}
                        <div class="bg-theme-primary/10 p-3 rounded-xl flex-shrink-0">
                            @switch($notification->data['type'] ?? 'default')
                                @case('deposit')
                                    <i data-lucide="arrow-down-circle" class="w-6 h-6 text-theme-primary"></i>
                                    @break
                                @case('withdrawal')
                                    <i data-lucide="arrow-up-circle" class="w-6 h-6 text-theme-primary"></i>
                                    @break
                                @case('investment')
                                    <i data-lucide="trending-up" class="w-6 h-6 text-theme-primary"></i>
                                    @break
                                @case('roi')
                                    <i data-lucide="piggy-bank" class="w-6 h-6 text-theme-primary"></i>
                                    @break
                                @default
                                   <i class="fas fa-bell" style="font-size: 1.5rem; color: #2563EB;"></i>
                            @endswitch
                        </div>

                        {{-- Content --}}
                        <div class="flex-grow">
                            <div class="text-sm text-gray-400 mb-1">
                                {{ $notification->created_at->diffForHumans() }}
                            </div>
                            <p class="text-gray-100">{{ $notification->data['message'] }}</p>
                            
                            {{-- Action Buttons --}}
                            <div class="flex items-center gap-4 mt-3">
                                @if(!$notification->read_at)
                                    <button wire:click="markAsRead('{{ $notification->id }}')" 
                                        class="text-sm text-theme-primary hover:text-theme-primary-dark transition-colors flex items-center gap-1">
                                       <i class="fas fa-check" style="font-size: 1rem;"></i>
                                        {{ __('t.mark_as_read') }}
                                    </button>
                                @endif
                                <button wire:click="deleteNotification('{{ $notification->id }}')" 
                                    class="text-sm text-red-400 hover:text-red-300 transition-colors flex items-center gap-1">
                                    <i class="fas fa-trash" style="font-size: 1rem;"></i>
                                    {{ __('t.delete') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="py-12 text-center">
                    <div class="bg-theme-tertiary w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <i data-lucide="bell-off" class="w-8 h-8 text-gray-400"></i>
                    </div>
                    <h3 class="text-lg font-medium text-gray-400">{{ __('t.no_notify') }}</h3>
                    <p class="text-gray-500 text-sm mt-1">{{ __('t.all_caught_up') }}</p>
                </div>
            @endforelse
        </div>

        {{-- Pagination --}}
        @if($notifications->hasPages())
            <div class="mt-6">
                {{ $notifications->links() }}
            </div>
        @endif
    </div>
</div>



