@use('\Illuminate\Support\Str', 'Str')
<div class="w-full p-2">
    <x-danger-alert />
    <x-success-alert />

    {{-- Plans Display (Initial View) --}}
    <div x-data="{ showPurchase: false, selectedPlan: null }" class="space-y-6">
        {{-- Plans Grid --}}
        <div x-show="!showPurchase" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 mt-2 mb-10 md:mb-1 gap-6">
            @foreach($plans as $plan)
                <div class="bg-theme-secondary rounded-2xl overflow-hidden">
                    {{-- Plan Header --}}
                    <div class="bg-theme-tertiary p-6">
                        <div class="flex items-center justify-between mb-4">
                            <h3 class="text-xl font-medium">{{ $plan->name }}</h3>
                            @if($plan->status == 'inactive')
                                <span class="px-3 py-1 text-xs bg-red-500/10 text-red-400 rounded-full">{{ __('t.inactive') }}</span>
                            @endif
                        </div>
                        <div class="space-y-1">
                            <div class="text-3xl font-bold text-theme-primary">
                                {{ Number::currency($plan->price, $settings->s_currency) }}
                            </div>
                            <p class="text-sm text-gray-400">{{ __('t.minimum_investment') }}</p>
                        </div>
                    </div>

                    {{-- Plan Features --}}
                    <div class="p-6 space-y-4">
                        {{-- Plan Description --}}
                        <div class="mb-4">
                            <p class="text-sm text-gray-300 line-clamp-4">
                                {{ $plan->description ?? __('t.default_plan_description') }}
                            </p>
                        </div>

                        {{-- Duration & ROI --}}
                        <div class="grid grid-cols-2 gap-4">
                            <div class="bg-theme-tertiary p-4 rounded-xl text-center">
                                <div class="text-sm text-gray-400 mb-1">{{ __('t.duration') }}</div>
                                <div class="font-medium">{{ $plan->duration }}</div>
                            </div>
                            <div class="bg-theme-tertiary p-4 rounded-xl text-center">
                                <div class="text-sm text-gray-400 mb-1">{{ __('t.roi') }}</div>
                                <div class="font-medium text-theme-primary">
                                    {{ $plan->increment_type === 'Percentage' ? 

    Number::percentage((float)$plan->min_return) . ' - ' . Number::percentage((float)$plan->max_return) : 

    Number::currency((float)$plan->increment_amount, $settings->s_currency)

}}


                                </div>
                            </div>
                        </div>

                        {{-- Feature List --}}
                        <div class="space-y-3">
                            <div class="flex items-center gap-2 text-sm">
                                <i class="fas fa-check text-theme-primary"></i>
                                <span>{{ __('t.min_return') }}: {{ $plan->min_return }}%</span>
                            </div>
                            <div class="flex items-center gap-2 text-sm">
                                <i class="fas fa-check text-theme-primary"></i>
                                <span>{{ __('t.max_return') }}: {{ $plan->max_return }}%</span>
                            </div>
                            <div class="flex items-center gap-2 text-sm">
                                <i class="fas fa-check text-theme-primary"></i>
                                <span>{{ __('t.bonus') }}: {{ Number::currency($plan->bonus, $settings->s_currency) }}</span>
                            </div>
                            <div class="flex items-center gap-2 text-sm">
                                <i class="fas fa-check text-theme-primary"></i>
                                <span>{{ Str::title($plan->increment_interval) }} {{ __('t.roi') }}</span>
                            </div>
                        </div>

                        {{-- Investment Button --}}
                        <button 
                            @click="showPurchase = true; $wire.selectPlan('{{ $plan->id }}')"
                            @disabled($plan->status !== 'active')
                            class="w-full bg-gradient-theme-primary text-black font-medium px-6 py-3 rounded-xl hover:brightness-110 transition-all disabled:opacity-50 disabled:cursor-not-allowed">
                            {{ __('t.invest') }}
                        </button>
                    </div>
                </div>
            @endforeach
        </div>

        {{-- Purchase View --}}
        <div x-show="showPurchase" x-transition class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            {{-- Left Column: Amount Input --}}
            <div class="lg:col-span-2">
                <div class="bg-theme-secondary rounded-2xl p-6 space-y-6">
                    {{-- Header with Back Button --}}
                    <div class="flex items-center justify-between">
                        <h3 class="text-lg font-medium">{{ __('t.investment_amount') }}</h3>
                        <button 
                            @click="showPurchase = false"
                            class="text-gray-400 hover:text-gray-300 transition-colors">
                            <i class="fas fa-arrow-left"></i>
                        </button>
                    </div>

                    {{-- Quick Amount Selection --}}
                    <div class="space-y-3">
                        <label class="text-sm text-gray-400">{{ __('t.quick_selection') }}</label>
                        <div class="grid grid-cols-3 gap-3">
                            @foreach([5000, 15000, 50000] as $quickAmount)
                                <button wire:click="$set('amount', '{{ $quickAmount }}')"
                                    class="px-4 py-3 bg-theme-tertiary hover:bg-theme-quaternary rounded-xl transition-colors text-center font-medium">
                                    {{ $settings->currency }}{{ number_format($quickAmount) }}
                                </button>
                            @endforeach
                        </div>
                    </div>

                    {{-- Custom Amount Input --}}
                    <div class="space-y-3">
                        <label class="text-sm text-gray-400">{{ __('t.custom_amount') }}</label>
                        <div class="bg-theme-tertiary rounded-xl p-4">
                            <div class="relative">
                                <div class="absolute left-0 top-1/2 -translate-y-1/2 text-xl font-medium text-theme-primary px-4">
                                    {{ $settings->currency }}
                                </div>
                                <input type="number" 
                                    wire:model.live='amount'
                                    class="w-full bg-transparent pl-12 text-xl font-medium focus:outline-none"
                                    placeholder="{{ __('t.enter_amount') }}"
                                    min="{{ $planSelected ? $planSelected->min_price : '0' }}"
                                    max="{{ $planSelected ? $planSelected->max_price : '10000000000' }}">
                            </div>
                            <div class="mt-4 flex items-center justify-between text-sm">
                                <span class="text-gray-400">{{ __('t.available_balance') }}</span>
                                <span class="font-medium">{{ Number::currency(auth()->user()->account_bal, $settings->s_currency) }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Right Column: Investment Summary --}}
            <div class="lg:col-span-1">
                <div class="bg-theme-secondary rounded-2xl p-6 space-y-6 mb-5 md:mb-1">
                    <h3 class="text-lg font-medium">{{ __('t.investment_summary') }}</h3>

                    <div class="space-y-4">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-400">{{ __('t.selected_plan') }}</span>
                            <span class="font-medium">{{ $planSelected ? $planSelected->name : '-' }}</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-400">{{ __('t.duration') }}</span>
                            <span class="font-medium">{{ $planSelected ? $planSelected->duration : '-' }}</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-400">{{ __('t.roi') }}</span>
                            <span class="font-medium text-theme-primary">{{ $roiInfo ?? '-' }}</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-400">{{ __('t.amount') }}</span>
                            <span class="font-medium">{{ $amount ? Number::currency($amount, $settings->s_currency) : '-' }}</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-400">{{ __('t.bonus') }}</span>
                            <span class="font-medium text-theme-primary">+{{ $planSelected ? Number::currency($planSelected->bonus, $settings->s_currency) : '-' }}</span>
                        </div>
                    </div>

                    {{-- Invest Button --}}
                    <form wire:submit="joinPlan">
                        <button type="submit" 
                            @disabled($disabled || ($planSelected && $planSelected->status !== 'active'))
                            class="w-full bg-gradient-theme-primary text-black font-medium px-6 py-4 rounded-xl hover:brightness-110 transition-all disabled:opacity-50 disabled:cursor-not-allowed flex items-center justify-center gap-2">
                            <div wire:loading wire:target="joinPlan">
                                <i class="fas fa-spinner fa-spin"></i>
                            </div>
                            <span wire:loading.remove wire:target="joinPlan">{{ __('t.confirm_investment') }}</span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        lucide.createIcons();
    </script>



