{{-- Mobile Navigation Bar --}}
<nav class="fixed bottom-0 left-0 right-0 bg-theme-secondary border-t border-gray-800/50 md:hidden z-50">
    <div class="max-w-screen-xl mx-auto">
        <div class="grid grid-cols-4 w-full">
            {{-- Deposit with Animation --}}
<a href="{{ route('user.deposit.make') }}" 
    @if($settings->spa_mode) wire:navigate @endif
    @class(['group relative flex flex-col items-center justify-center px-2 py-4 transition-colors',
        'text-theme-primary' => request()->routeIs('user.deposit.*'),
        'text-gray-400' => !request()->routeIs('user.deposit.*')])>
    <div class="relative w-10 h-10 flex items-center justify-center animate-bounce">
        <div class="w-full h-full absolute bg-theme-primary/5 rounded-xl group-hover:bg-theme-primary/10 transition-colors"></div>
        <i class="fas fa-coins w-5 h-5"></i>
        <div class="absolute inset-0 bg-theme-primary/10 rounded-xl scale-0 group-hover:scale-100 transition-transform"></div>
    </div>
    <span class="text-xs mt-1 font-medium group-hover:text-theme-primary transition-colors">{{ __('t.deposit') }}</span>
    @if(request()->routeIs('user.deposit.*'))
        <div class="absolute top-0 left-1/2 -translate-x-1/2 w-8 h-1 bg-theme-primary rounded-b-full"></div>
    @endif
</a>

{{-- Menu Toggle (moved to center to avoid live chat) --}}
<button id="mobileMenuToggle" 
    class="group relative flex flex-col items-center justify-center px-2 py-4 w-full text-gray-400">
    <div class="relative w-12 h-12 flex items-center justify-center">
        <div class="w-full h-full absolute bg-theme-primary/10 rounded-full group-hover:bg-theme-primary/20 transition-colors"></div>
        <i class="fas fa-bars w-6 h-6 text-theme-primary"></i>
        <div class="absolute inset-0 bg-theme-primary/20 rounded-full scale-0 group-hover:scale-100 transition-transform"></div>
    </div>
    <span class="text-xs mt-1 font-medium text-theme-primary">{{ __('t.menu') }}</span>
</button>

{{-- Dashboard (Home) --}}
<a href="{{ route('user.dashboard') }}" 
    @if($settings->spa_mode) wire:navigate @endif
    @class(['group relative flex flex-col items-center justify-center px-2 py-4 transition-colors',
        'text-theme-primary' => request()->routeIs('user.dashboard'),
        'text-gray-400' => !request()->routeIs('user.dashboard')])>
    <div class="relative w-10 h-10 flex items-center justify-center">
        <div class="w-full h-full absolute bg-theme-primary/5 rounded-xl group-hover:bg-theme-primary/10 transition-colors"></div>
        <i class="fas fa-home w-5 h-5"></i>
        <div class="absolute inset-0 bg-theme-primary/10 rounded-xl scale-0 group-hover:scale-100 transition-transform"></div>
    </div>
    <span class="text-xs mt-1 font-medium group-hover:text-theme-primary transition-colors">{{ __('t.home') }}</span>
    @if(request()->routeIs('user.dashboard'))
        <div class="absolute top-0 left-1/2 -translate-x-1/2 w-8 h-1 bg-theme-primary rounded-b-full"></div>
    @endif
</a>

{{-- Withdraw --}}
<a href="{{ route('user.withdraw.request') }}" 
    @if($settings->spa_mode) wire:navigate @endif
    @class(['group relative flex flex-col items-center justify-center px-2 py-4 transition-colors',
        'text-theme-primary' => request()->routeIs('user.withdraw.*'),
        'text-gray-400' => !request()->routeIs('user.withdraw.*')])>
    <div class="relative w-10 h-10 flex items-center justify-center">
        <div class="w-full h-full absolute bg-theme-primary/5 rounded-xl group-hover:bg-theme-primary/10 transition-colors"></div>
        <i class="fas fa-wallet w-5 h-5"></i>
        <div class="absolute inset-0 bg-theme-primary/10 rounded-xl scale-0 group-hover:scale-100 transition-transform"></div>
    </div>
    <span class="text-xs mt-1 font-medium group-hover:text-theme-primary transition-colors">{{ __('t.withdraw') }}</span>
    @if(request()->routeIs('user.withdraw.*'))
        <div class="absolute top-0 left-1/2 -translate-x-1/2 w-8 h-1 bg-theme-primary rounded-b-full"></div>
    @endif
</a>
        </div>
    </div>
</nav>

@push('scripts')
<script>
    // Mobile menu toggle functionality
    document.addEventListener('DOMContentLoaded', function() {
        const mobileMenuToggle = document.getElementById('mobileMenuToggle');
        const mobileSidebar = document.getElementById('mobileSidebar');
        const closeMobileSidebar = document.getElementById('closeMobileSidebar');

        if (mobileMenuToggle && mobileSidebar && closeMobileSidebar) {
            // Toggle menu
            mobileMenuToggle.addEventListener('click', () => {
                mobileSidebar.classList.toggle('hidden');
            });

            // Close menu
            closeMobileSidebar.addEventListener('click', () => {
                mobileSidebar.classList.add('hidden');
            });

            // Close on outside click
            mobileSidebar.addEventListener('click', (e) => {
                if (e.target === mobileSidebar) {
                    mobileSidebar.classList.add('hidden');
                }
            });
        }
    });
</script>
@endpush





