@forelse($trades as $trade)
    <tr class="hover:bg-gray-800/30 transition-colors" data-trade-id="{{ $trade->id }}">
        <td class="px-4 py-3 text-sm">
            {{ $trade->created_at->diffForHumans() }}
        </td>
        <td class="px-4 py-3">
            <span class="px-2 py-1 rounded text-xs font-medium {{ $trade->type === 'Rise' ? 'bg-green-500/10 text-green-500' : 'bg-red-500/10 text-red-500' }}">
                {{ $trade->type }}
            </span>
        </td>
        <td class="px-4 py-3 text-sm">
            ${{ number_format($trade->amount, 2) }}
        </td>
        <td class="px-4 py-3 font-mono text-sm">
            ${{ number_format($trade->entry_price, 2) }}
        </td>
        <td class="px-4 py-3 text-sm">
            <div data-status="{{ $trade->status }}">
                @if($trade->status === 'active')
                    <div class="flex items-center gap-1.5 text-yellow-500">
                        <i class="fas fa-circle-notch fa-spin text-xs"></i>
                        <span>Active</span>
                    </div>
                @elseif($trade->status === 'completed')
                    <span class="text-{{ $trade->result === 'win' ? 'green' : 'red' }}-500">
                        {{ ucfirst($trade->result) }}
                    </span>
                @else
                    <span class="text-gray-400">{{ ucfirst($trade->status) }}</span>
                @endif
            </div>
        </td>
        <td class="px-4 py-3 text-sm">
            @if($trade->status === 'completed')
                <span class="font-medium {{ $trade->profit_amount >= 0 ? 'text-green-500' : 'text-red-500' }}">
                    {{ $trade->profit_amount >= 0 ? '+' : '' }}${{ number_format($trade->profit_amount, 2) }}
                </span>
            @else
                <span class="text-gray-400">--</span>
            @endif
        </td>
    </tr>
@empty
    <tr>
        <td colspan="6" class="px-4 py-8 text-center text-gray-400">
            <div class="flex flex-col items-center">
                <div class="w-16 h-16 mb-4 rounded-full bg-gray-800/50 flex items-center justify-center">
                    <i class="fas fa-chart-line text-2xl"></i>
                </div>
                <p class="mb-2">No trades yet</p>
                <p class="text-sm text-gray-500 mb-4">Place your first trade to start your journey</p>
                <a href="{{ route('user.trading.trade') }}" class="text-theme-primary hover:underline">
                    Start Trading
                </a>
            </div>
        </td>
    </tr>
@endforelse





