<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetDefaultLocaleHeaders
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);
        
        if (method_exists($response, 'header')) {
            // Set content language header
            $response->header('Content-Language', app()->getLocale());
            
            // Set vary header to ensure proper caching
            $response->header('Vary', 'Accept-Language');
            
            // Set cache control for locale-specific content
            $response->header('Cache-Control', 'private, must-revalidate');
        }
        
        return $response;
    }

    /**
     * Determine if request has locale parameter.
     */
    private function hasLocaleParameter(Request $request): bool
    {
        return $request->has('locale') && 
               array_key_exists($request->locale, config('app.available_locales'));
    }
}