<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Trade;
use Illuminate\Http\Request;

class TradingManagementController extends Controller
{
    public function allTrades()
    {
        $trades = Trade::with('user')
            ->latest()
            ->paginate(15);
            
        return view('admin.trading.all', compact('trades'));
    }

    public function pendingTrades()
{
    $trades = Trade::with('user')
        ->where('status', 'active')
        ->latest()
        ->paginate(15);
        
    return view('admin.trading.pending', compact('trades'));
}

public function updateTrade(Request $request, Trade $trade)
{
    $validated = $request->validate([
        'expected_result' => 'required|string|in:win,loss',
        'profit_amount' => 'required|numeric|decimal:0,2'
    ]);

    if ($validated['expected_result'] === 'loss') {
        $validated['profit_amount'] = -abs($validated['profit_amount']);
    } else {
        $validated['profit_amount'] = abs($validated['profit_amount']);
    }

    $trade->update($validated);

    return back()->with('success', 'Trade updated successfully');
}

    public function completedTrades()
    {
        $trades = Trade::with('user')
            ->where('status', 'completed')
            ->latest()
            ->paginate(15);
            
        return view('admin.trading.completed', compact('trades'));
    }
}